<?php



// --------------------------------------------------------- //
// ----------- General RESTfull API Engine ----------------- //
// --------------------------------------------------------- //
abstract class API
{

    public static $VERSION_NUMBER = 3.0;
    private $_request = array();
    private $_time_start = 0;

    // ------------------------------------------------------- //
    // ----------------- Constructor ------------------------- //
    // ------------------------------------------------------- //
    public function __construct()
    {

        $this->_time_start = microtime(true);

        set_exception_handler('API::exceptionHandler');
        set_error_handler('API::errHandle');
        self::cors();

        switch ($_SERVER['REQUEST_METHOD']) {
            case "POST":
                $postBody = file_get_contents('php://input');
                if (!json_decode($postBody)) {
                    parse_str($postBody, $postBody);
                    $postBody = json_encode($postBody, JSON_UNESCAPED_UNICODE);
                }
                $this->_request = json_decode($postBody);
                break;
            case "GET":
                $this->_request = $this->cleanInputs($_GET);
                break;
        }

        //throw exception in case the user does not provide method name
        if (!array_key_exists("method", $this->_request)) {
            throw new Exception("Method is not provided", 0);
        }

        $param = json_decode(json_encode($this->_request));
        try {
            $headers = $this->getRequestHeaders();
            if ($param->integration_token) {
            }
            if ($headers['refresh-token'] != null) {
                $param->refresh_token = $headers['refresh-token'];
            }
            if ($headers['integration_token'] != null && $headers['integration_token'] != "") {
                $param->integration_token = $headers['integration_token'];
            }
            if ($headers['v'] != null) {
                if ($headers['v'] != self::$VERSION_NUMBER) {
                    throw new Exception("API_VERSION_MISMATCH");
                }
            }
        } catch (Exception $e) {
        }

        return $param;
    }

    public function getRequestHeaders()
    {
        $headers = array();
        if ($_SERVER) {
            foreach ($_SERVER as $key => $value) {
                $header = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
                $headers[strtolower($header)] = $value;
            }
        }

        return $headers;
    }
    // ----------------------------------------------------------- //
    // -------------generate reposnse with error code 200--------- //
    // ----------------------------------------------------------- //
    public function response($data)
    {
        header("HTTP/1.1 200 OK");
        header("Content-Type: application/json");

        if (getenv('debug_mode') == 1) { // for timing and debuging purposes, turn this on from app.yaml
            $time_end = microtime(true);
            $time = round(($time_end - $this->_time_start) * 1000);
            $Result['result'] = $data;
            $Result['totalDurationProcessing'] = $time;
            $data = $Result;
        }
        echo (json_encode($data, JSON_UNESCAPED_UNICODE));
    }



    // ------------------------------------------------------------------------- //
    // -------------clean the params sent to API and store it in struct--------- //
    // ------------------------------------------------------------------------- //
    private function cleanInputs($data)
    {
        $clean_input = array();
        if (is_array($data)) {
            foreach ($data as $k => $v) {
                $clean_input[trim(strtolower($k))] = $this->cleanInputs(trim($v));
            }
        } else {
            if (get_magic_quotes_gpc()) {
                $data = trim(stripslashes($data));
            }
            $data = strip_tags($data);
            $clean_input = trim($data);
        }
        return $clean_input;
    }


    // ----------------------------------------------------- //
    // -------------Error Handler like any --------------------- //
    // ----------------------------------------------------- //
    public static function errHandle($level, $text, $file, $line)
    {
        if (!in_array($level, [8, 512, 1024])) { // exclude system and user notice
            throw new Exception($text, 0);
        }
    }

    // ----------------------------------------------------- //
    // -------------Exception Handler ---------------------- //
    // ----------------------------------------------------- //
    public static function exceptionHandler($exception)
    {

        $errorMessage = '';

        // convert DB error messages
        if (strpos($exception->getMessage(), '100 Phone Duplicate!') !== false) {
            $errorMessage = 'رقم الهاتف مستخدم مسبقا';
        }
        if (strpos($exception->getMessage(), 'nn_nat_idx') !== false) {
            $errorMessage = 'الرقم الوطني مستخدم مسبقا';
        }
        if (strpos($exception->getMessage(), '100 No Authority!') !== false) {
            $errorMessage = 'لا يوجد لديك صلاحية ﻹتمام هذه العملية';
        }
        if (strpos($exception->getMessage(), ' 100 رقم الهاتف غير صحيح') !== false) {
            $errorMessage = 'رقم الهاتف غير صحيح';
        }

        if (strpos($exception->getMessage(), "uk_waybill_active_truck")) {
            $errorMessage =  "لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "uk_waybill_active_trailer")) {
            $errorMessage = "لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "uk_waybill_active_driver")) {
            $errorMessage = "لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "لا يوجد رصيد كافي بالحساب")) {
            $errorMessage = "لا يوجد رصيد كافي بالحساب";
        }

        if ($errorMessage == '') {
            $errorMessage = $exception->getMessage();
        }


        header("HTTP/1.1 500 Internal Server Error");
        $Result['ERRORCODE'] = $exception->getCode() ? $exception->getCode() : 500;
        $Result['CODE'] = $errorMessage;
        $Result['MESSAGE'] = $errorMessage;
        $Result['TRACE'] = $exception->getTrace();

        $isDebugMode = 0;
        if ($isDebugMode) {
            echo (json_encode($Result, JSON_UNESCAPED_UNICODE));
        } else {
            header("Content-Type: application/json");
            echo (json_encode($Result, JSON_UNESCAPED_UNICODE));
        }
    }

    public static function cors()
    {

        // Allow from any origin
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            $http_origin = $_SERVER['HTTP_ORIGIN'];
            header("Access-Control-Allow-Origin: $http_origin");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day            
        } else {
            header("Access-Control-Allow-Origin: *");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day            
        }

        // enable SameSite cookie
        if (isset($_COOKIE["PHPSESSID"])) {
            header('Set-Cookie: PHPSESSID=' . $_COOKIE["PHPSESSID"] . ';Secure; SameSite=None');
        }
        header('Set-Cookie: PHPSESSID=e14sov5ir0s7n4q3huu8ghvk1r; Secure; SameSite=None');

        // header('Set-Cookie: env=Dev ;Secure; SameSite=None');    

        // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }
    }
}
