<?php
ini_set('max_execution_time','300');
ini_set('memory_limit',-1);
require_once (dirname(__FILE__)."/include/debug.php");   
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
cors();

// --------- Constructor ---------------------------------------------------
switch ($_SERVER['REQUEST_METHOD']) {
    case "POST":
        $postBody = file_get_contents('php://input');
        if (!json_decode($postBody)) {
            parse_str($postBody, $postBody);
            $postBody = json_encode($postBody, JSON_UNESCAPED_UNICODE);
        }
        $request = json_decode($postBody);
        break;
    case "GET":
        $request = cleanInputs($_GET);
        break;
}

function getRequestHeaders()
{
    $headers = array();
    foreach ($_SERVER as $key => $value) {
        $header = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
        $headers[strtolower($header)] = $value;
    }
    return $headers;
}

function cleanInputs($data)
{
    $clean_input = array();
    if (is_array($data)) {
        foreach ($data as $k => $v) {
            $clean_input[trim(strtolower($k))] = cleanInputs(trim($v));
        }
    } else {

        $data = trim(stripslashes($data));

        $data = strip_tags($data);
        $clean_input = trim($data);
    }
    return $clean_input;
}

function cors(){

    // Allow from any origin
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        $http_origin = $_SERVER['HTTP_ORIGIN'];
        header("Access-Control-Allow-Origin: $http_origin");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }else{
        header("Access-Control-Allow-Origin: *");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }

    // enable SameSite cookie
    if(isset($_COOKIE["PHPSESSID"])){
        header('Set-Cookie: PHPSESSID=' . $_COOKIE["PHPSESSID"]. '; SameSite=None; Secure');
    }


    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            // may also be using PUT, PATCH, HEAD etc
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
            header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

        exit(0);
    }

    //echo "You have CORS!";
}


function response($data)
{
    header("HTTP/1.1 200 OK");
    header("Content-Type: application/json");

    if (getenv('debug_mode') == 1) { // for timing and debuging purposes, turn this on from app.yaml
        $time_end = microtime(true);
        $Result['result'] = $data;
        $data = $Result;
    }
    echo (json_encode($data, JSON_UNESCAPED_UNICODE));
}

$param = json_decode(json_encode($request));
$data = json_encode($param->data);
$str = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $data);
$json = json_decode($str, true);
simulate($json);

// ----------------------------------------------------


function needsInspection($prob=0){ 
    $rnd = uniformRand(); 
    return($rnd<=$prob?true:false);
}

function debug($text){ 
   // echo $text;
}
function loadTimeOfDay($shift=0){
    $trunc = .025;
    $rnd = uniformRand()*(1-(2*$trunc))+$trunc;
    $hour = round(stats_cdf_normal($rnd,1200,620,2))+($shift*100);
    if($hour>=2400) $hour = $hour-2400;
    if($hour<0) $hour = $hour+2400;
    $hour=str_pad((string)$hour, 4, "0", STR_PAD_LEFT); 
    $m = substr($hour,0,2)*60;
    $s = substr($hour,2,2)*60*60/100;
    return round($m*60+$s);
}

function dwellTime($mean, $var=3, $scale=1, $shift=0){
    return stats_cdf_gamma(uniformRand()*$scale+$shift,$mean/$var,$var,2);
}

function vesselCapacity($mean,$var=25, $p=0){
    if(needsInspection($p)){
        $capacity = round(stats_cdf_gamma(uniformRand(),0.5*$mean/$var,$var,2));
    }else{
        $capacity = round(stats_cdf_gamma(uniformRand(),1.5*$mean/$var,$var,2));
    }
    return $capacity;
}

function uniformRand(){
    return rand(1,999999)/1000000;
}

function cntGoutTime(){
    return round(dwellTime($GLOBALS['doc']['org']['cnt_dwell'],$GLOBALS['doc']['org']['cnt_dwell'],0.9,0.1))*24*60*60 + loadTimeOfDay($GLOBALS['doc']['org']['peack_hour']);
}

function cntRoadTime(){
    return round(dwellTime($GLOBALS['doc']['truck']['trip_time'],3,0.9,0.1)*60);
}

function addSec($date,$step){
    return date('Y-m-d H:i', strtotime($date. ' +'.$step.' seconds'));
}


function simulate($doc){
    $startProcess = microtime(true);
    $GLOBALS['doc'] = $doc;
    $GLOBALS['doc']['org']['peack_hour'] = $GLOBALS['doc']['org']['peack_hour'] - 12;
    $totalSeconds = ($GLOBALS["doc"]['org']['cnt_dwell'] + $doc['settings']['duration']+$GLOBALS["doc"]['org']['cnt_dwell'])*24*60*60;
    $step = $doc['settings']['step'];
    $startTime = addSec('2020-01-01 00:00',$GLOBALS["doc"]['org']['cnt_dwell']*(-24*60*60*2));
    $GLOBALS['containers']=[];
    $GLOBALS['complete']=[];
    $GLOBALS['queues']=[];
    $GLOBALS['ramps']=[];
    $GLOBALS['waiting']=[];
    $GLOBALS['cid']=0;

    foreach ($GLOBALS["doc"]['dest']['inspection'] as $key => $insp) {
        foreach ($insp['ramps'] as $key => $value) {
            $GLOBALS['ramps'][$value]=null;
        }

        foreach ($insp['queues'] as $key => $value) {
            
            $found_key =  array_search($value, array_column($GLOBALS["doc"]['dest']['queues'], 'id'));
            $GLOBALS['queues'][$value]=array(
                "id"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['id'],
                "capacity"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['capacity'],
                "available"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['capacity'],
                "containers"=>[]
            );
        }
    }
    $GLOBALS['overflow']=[];
    $voyage=[];
    $startInterval = addSec($startTime,-1*$step);
    $steps = 0;
    for ($start=$step; $start < $totalSeconds + $step; $start=$start+$step) { // Mian simulation loop
        $complete_percentage = round($start/$totalSeconds*100); // To be sent to web socket
        $end = $start+$step;
        $steps++;
        $endInterval = addSec($startInterval,$step);
        $GLOBALS['currentTime']=$endInterval;

        if(date("d", strtotime($startInterval)) != date("d", strtotime($GLOBALS['currentTime']))){ // New Day Detected
            if($GLOBALS['doc']['supply']['supply_mode']=="random"){
                if(needsInspection($GLOBALS["doc"]['supply']['annual_rate']/365)){
                    $containersInVoyage = vesselCapacity($GLOBALS["doc"]['supply']['containers']);
                    createVoyageCnt($GLOBALS['containers'],$containersInVoyage,$GLOBALS['currentTime']);
                    $voyage[]=array("startTime"=>$GLOBALS['currentTime'],"containers"=>$containersInVoyage);
                }    
            }else{
                $dailyContainers = round($GLOBALS["doc"]['supply']['annual_rate'] * $GLOBALS["doc"]['supply']['containers'] /365);
                createVoyageCnt($dailyContainers,$GLOBALS['currentTime']);
                $voyage[]=array("startTime"=>$GLOBALS['currentTime'],"containers"=>$dailyContainers);
            }
        }
        foreach ($GLOBALS['containers'] as $id => &$cnt) {
            updateCntStatus($GLOBALS['containers'][$id],$GLOBALS['currentTime']);
        }
       
        getNextQ();
        
        // debug("[".$GLOBALS['currentTime']."] - Ramps Capacity: ".$GLOBALS['inspection']['all_purpose']['available']."<br>");
        // debug("[".$GLOBALS['currentTime']."] - Queue Capacity: ".$GLOBALS['queues']['all_purpose']['available']."<br>");
        
        if($GLOBALS['currentTime']>'2020-01-01 00:00'){
            $output=&$GLOBALS['output'];
            $output['snapshoot'][]=array("ts"=>$GLOBALS['currentTime'],"h"=>[],"s"=>[]);

            foreach ($GLOBALS['queues'] as $q => &$queue) {
                $i=0;
                foreach ($queue['containers'] as $cid) {
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]=$queue['id']."L".$i;
                    $i++;
                }
                for ($j=$i; $j < $queue['capacity']; $j++) { 
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]=$queue['id']."L".$j;
                }
            }
            foreach ($GLOBALS['ramps'] as $r => $cid) {
                if($cid != null){
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]="R".$r;
                }else{
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]="R".$r;
                }
            }

            for ($i=1; $i <= $GLOBALS['doc']['dest']['overflow']['count']; $i++) {
                if($i <= sizeof($GLOBALS['overflow'])){
                    $cid = $GLOBALS['overflow'][$i-1];
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]="O".$i;
                }else {
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]="O".$i;
                }
            }

            for ($i=1; $i <= $GLOBALS['doc']['dest']['clear']['capacity']; $i++) {
                if($i <= sizeof($GLOBALS['waiting'])){
                    $cid = $GLOBALS['waiting'][$i-1];
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]="W".$i;
                }else {
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]="W".$i;
                }
            }


            $street = sizeof($GLOBALS['overflow']) - $GLOBALS['doc']['dest']['overflow']['count'];
            if($street > 0){
                $output['snapshoot'][sizeof($output['snapshoot'])-1]['street']=$street;
            }else {
                $output['snapshoot'][sizeof($output['snapshoot'])-1]['street']=0;
            }
            

            // echo $GLOBALS['currentTime']." ";
            // foreach ($GLOBALS['queues'] as $q => &$queue) {
            //     for ($i=0; $i < $queue['capacity']; $i++) { 
            //         if($i<$queue['capacity'] -$queue['available']){
            //             echo 1;
            //         }
            //     }
            // }
            // foreach ($GLOBALS['queues'] as $q => &$queue) {
            //     for ($i=0; $i < $queue['capacity']; $i++) { 
            //         if($i>=$queue['capacity'] -$queue['available']){
            //             echo 0;
            //         }
            //     }
            // }
            // echo ' ';
            // foreach ($GLOBALS['ramps'] as $r => &$ramp) {
            //     if($ramp != null){
            //         echo 1;
            //     }
            // }
            // foreach ($GLOBALS['ramps'] as $r => &$ramp) {
            //     if($ramp == null){
            //         echo 0;
            //     }
            // }
            // echo "\n";
        }
        //dump($GLOBALS['containers']); die;
        foreach ($GLOBALS['containers'] as $c => &$cnt) {
            
            
        }
        //debug("[".$GLOBALS['currentTime']."] - Queue overflow: ".sizeof($GLOBALS['overflow'])."<br>");
        $startInterval=$GLOBALS['currentTime'];
    }

    //file_put_contents("output.json", json_encode($output));

    $v = [];
    foreach ($voyage as $key => $value) {
        if (!isset($v[substr($value['startTime'], 0, 7)])) $v[substr($value['startTime'], 0, 7)] = 0;
        $v[substr($value['startTime'], 0, 7)] += $value['containers'];
    }
    $time_elapsed_secs = microtime(true) - $startProcess;
    $output['voyage'] = $voyage;
    response($output);

    debug("[" . $GLOBALS['currentTime'] . "]time elapse=" . $time_elapsed_secs . "<br>Containers=" . sizeof($GLOBALS['output']['containers']['inspection']));

}

function createVoyageCnt($count,$ts){
    for ($i=0; $i < $count; $i++) {
        $id=$GLOBALS['cid']++;
        $GLOBALS['containers'][$id] = createCnt($id,$ts);
        updateCntStatus($GLOBALS['containers'][$id],$ts);
    }
}

function createCnt($id,$ts){
    $totalProb = 1;
    foreach ($GLOBALS["doc"]['dest']['inspection'] as $cargoType => $value) {
        $needsInspection = needsInspection($value['prob']/(100*$totalProb));
        $totalProb = $totalProb - $value['prob']/100;
        if($needsInspection){
            $inspection = array(
                "include"=> true,
                "type"=>$cargoType,
                "color"=>$value['color'],
                "time" => round(dwellTime($value['time'])*60)
            );
            break;
        } 
    }
    if(!$needsInspection){
        $inspection = array("include"=> false);
    }
    
    $cnt = array(
        "id"=>$id,
        "status"=>"voyage",
        "drop_time"=>9,
        "gout_time"=>9,
        "arrive_time"=>9,
        "inspection_start"=>9,
        "clear_start"=>9,
        "release_time"=>9,
        "inspection"=>$inspection
    );
    $cnt['drop_time']=$ts;
    $cnt['gout_time']=addSec($cnt['drop_time'], cntGoutTime());
    if($cnt['inspection']['include']){
        $cnt['arrive_time']=addSec($cnt['gout_time'], cntRoadTime());

    }else{
        $cnt['release_time']=addSec($cnt['gout_time'], cntRoadTime());
    }
    return $cnt;
}


function updateCntStatus(&$cnt,$ts){
    if($cnt['status']=="voyage" and $cnt['drop_time'] <= $ts) {
        $cnt['status']="origin";
    }

    if($cnt['status']=="origin" and $cnt['gout_time'] <= $ts ) {
        $cnt['status']="road";
    }

    if($cnt['status']=="road"){
        if($cnt['inspection']['include']){
            if($cnt['arrive_time'] <= $ts ) {
                // debug("[".$GLOBALS['currentTime']."] - Add to Q: ".$cnt['id']."<br>");
                addToQ($cnt);
            }
        }else{
            if($cnt['arrive_time'] <= $ts ) {
                release($cnt);
            }
        }
    }

    if($cnt['status']=="inspect" and $cnt['clear_start'] <= $ts){
        // debug( "[".$GLOBALS['currentTime']."] - Clear: ".$cnt['id']."<br>");
        clear($cnt);
    }
    if($cnt['status']=="clearing" and $cnt['release_time'] <= $ts){
        // debug( "[".$GLOBALS['currentTime']."] - release: ".$cnt['id']."<br>");
        release($cnt);
    }


}

function comp($a, $b , $key) {
    return ($a[$key]==$b[$key]?0:($a[$key]<$b[$key])?1:-1);
}
 
function addToQ(&$cnt){
    $inspSettings = $GLOBALS['doc']['dest']['inspection'][$cnt['inspection']['type']];
    $selectedQueue = null;
    $cnt['status']="queue";
    
    if(sizeof($GLOBALS['overflow']) == 0 or (sizeof($GLOBALS['overflow']) > 0 and $GLOBALS['overflow'][0]==$cnt['id'])){
        usort($GLOBALS['queues'],function($a,$b){return comp($a,$b,'available');}); 
        foreach($GLOBALS['queues'] as $q => &$queue) {   
            $found_queue_idx = array_search($queue['id'],$inspSettings['queues']);
            if($found_queue_idx !== false and $queue['available']>0){
                $selectedQueue = &$queue;
                break;
            } 
        }
        debug("[".$GLOBALS['currentTime']."] - Add to Q: ".$cnt['id']."<br>");
    }
    if($selectedQueue == null){
        // add to overflow if not added
        if(!isset($cnt['inspection']['overflow']["start"])){
            $GLOBALS['overflow'][]=$cnt['id'];
            $cnt['inspection']['overflow']["start"]=$GLOBALS['currentTime'];
            debug("[".$GLOBALS['currentTime']."] - Add container to overflow (" .sizeof($GLOBALS['overflow']). ") : " .$cnt['id']."<br>");
        }
    }else{
        $selectedQueue['available'] = $selectedQueue['available'] - 1;
        $selectedQueue['containers'][]=$cnt['id'];
        $cnt['inspection']['actualQueue']=$selectedQueue['id'];
        return true;
    }
    return false;
}


function removeQ(&$cnt){
    $found_queue_idx = array_search($cnt['inspection']['actualQueue'], array_column($GLOBALS['queues'], 'id'));
    $GLOBALS['queues'][$found_queue_idx]['available']++;
    array_splice($GLOBALS['queues'][$found_queue_idx]['containers'],0,1);
    debug("[".$GLOBALS['currentTime']."] - remove Q: ".$found_queue_idx." - ".$cnt['id']."<br>");
    getFromOverflow();
    
}

function getFromOverflow(){
    while (sizeof($GLOBALS['overflow'])>0) {
        $cnt=&$GLOBALS['containers'][$GLOBALS['overflow'][0]];
        if(!addToQ($cnt)){
            break;
        }
        $cnt['inspection']['overflow']["end"]=$GLOBALS['currentTime'];
        array_splice($GLOBALS['overflow'],0,1);
        debug( "[".$GLOBALS['currentTime']."] - Remove container from overflow (" . sizeof($GLOBALS['overflow']) . ") :".$cnt['id']."<br>");
    }
}

function checkCntId($fn){
    foreach ($GLOBALS['containers'] as $key => $value) {
        if($key!=$value['id']){
            echo $fn." - ".$key." - ".$value['id'];
            dump($GLOBALS['containers']);
            return false;
        }
    }
    return true;
}

function getNextQ($counter=1){
    usort($GLOBALS['queues'],function($b,$a){return comp($a,$b,'available');});
    $inpectionDone = false;
    foreach ($GLOBALS['queues'] as &$queue) {
        if(sizeof($queue['containers'])){
            $type = $GLOBALS['containers'][$queue['containers'][0]]['inspection']['type'];
            $targetRamps = $GLOBALS['doc']['dest']['inspection'][$type]['ramps'];
            foreach ($targetRamps as $key => $rampIdx) {
                if($GLOBALS['ramps'][$rampIdx] == null){
                    inspect($GLOBALS['containers'][$queue['containers'][0]],$rampIdx);
                    $inpectionDone = true;
                    break;
                }
            }
        }
    }
    if($inpectionDone){
        getNextQ($counter++);
    }
}

function inspectiontimeShift($ts){
    $ts=substr($ts,11,2)*60*60+substr($ts,14,2)*60;
    $start = substr($GLOBALS['doc']['dest']['working_hours']['start'],0,2) *60*60 +
            substr($GLOBALS['doc']['dest']['working_hours']['start'],2,2) *60;
    $end = substr($GLOBALS['doc']['dest']['working_hours']['end'],0,2) *60*60 +
            substr($GLOBALS['doc']['dest']['working_hours']['end'],2,2) *60;
    
    if($ts>$end){
        $shift = 24*60*60 - $ts + $start;
    }elseif($ts<$start){
        $shift = $start - $ts;
    }else{
        $shift = 0;
    }
    return $shift;
}


function seconds($ts){
    return substr($ts,11,2)*60+substr($ts,14,2)*60*60;
}

function inspect(&$cnt,$rampId){
    $ramp = &$GLOBALS['ramps'][$rampId];
    removeQ($cnt);
    $GLOBALS['ramps'][$rampId]=$cnt['id'];  
    $cnt['status']="inspect";
    $duration = $GLOBALS['doc']['dest']['inspection'][$cnt['inspection']['type']]['time'];
    $duration = round(dwellTime($duration)*60);
    $cnt['inspection_start']=addSec($GLOBALS['currentTime'],inspectiontimeShift($GLOBALS['currentTime']));
    $cnt['clear_start']=addSec($cnt['inspection_start'],$duration);
    $cnt['inspection']['actualRamp']=$rampId;
    // debug( "[".$GLOBALS['currentTime']."] - inspect: ".$cnt['id']."<br>");

}

function clear(&$cnt){
    $cnt['status']="clearing";
    $selectedRamp=$cnt['inspection']['actualRamp'];
    $cnt['release_time']=addSec($cnt['clear_start'],round(dwellTime($GLOBALS["doc"]["dest"]['clear']['time']*60)));
    unset($GLOBALS['ramps'][$cnt['inspection']['actualRamp']]);
    $GLOBALS['waiting'][]=$cnt['id']; 
    $GLOBALS['ramps'][$cnt['inspection']['actualRamp']] = null;
    getNextQ();
}   

function release(&$cnt){
    $cnt['status']="release";
    $GLOBALS['complete'][$cnt['id']]=$cnt;
    if($cnt['inspection']['include']){
        array_splice($GLOBALS['waiting'],array_search($cnt['id'],$GLOBALS['waiting']),1);

        if(isset($cnt['inspection']['overflow']["start"]) and isset($cnt['inspection']['overflow']["end"])){
            $overflow = [$cnt['inspection']['overflow']["start"],$cnt['inspection']['overflow']["end"]];
        }else{
            $overflow = [null,null];
        }
        $GLOBALS['output']['containers']['inspection'][]=
            array(
                $cnt['inspection']['type'],
                $cnt['drop_time'],
                $cnt['gout_time'],
                $cnt['arrive_time'],
                $cnt['inspection_start'],
                $cnt['clear_start'],
                $cnt['release_time'],
                $overflow[0],$overflow[1]
            );    
    }else{
        $GLOBALS['output']['containers']['none'][]=
            array(
                $cnt['drop_time'],
                $cnt['gout_time'],
                $cnt['release_time']
            );

    }
    unset($GLOBALS['containers'][$cnt['id']]);
}   