
<?php
ini_set('max_execution_time','300');
require_once (dirname(__FILE__)."/include/debug.php");   
set_error_handler('exceptions_error_handler');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('memory_limit', '-1');

function exceptions_error_handler($severity, $message, $filename, $lineno) {
  if (error_reporting() == 0) {
    return;
  }
  if (error_reporting() & $severity) {
    throw new ErrorException($message, 0, $severity, $filename, $lineno);
  }
}

$cntSeq = 1;

function needsInspection($prob=0){
    $rnd = uniformRand();
    return($rnd<=$prob?true:false);
}

function debug($text){
    echo $text;
}
function loadTimeOfDay($shift=0){
    $trunc = .025;
    $rnd = uniformRand()*(1-(2*$trunc))+$trunc;
    $hour = round(stats_cdf_normal($rnd,1200,620,2))+($shift*100);
    if($hour>=2400) $hour = $hour-2400;
    if($hour<0) $hour = $hour+2400;
    $hour=str_pad((string)$hour, 4, "0", STR_PAD_LEFT); 
    $m = substr($hour,0,2)*60;
    $s = substr($hour,2,2)*60*60/100;
    return round($m*60+$s);
}

function dwellTime($mean, $var=3, $scale=1, $shift=0){
    return stats_cdf_gamma(uniformRand()*$scale+$shift,$mean/$var,$var,2);
}

function vesselCapacity($mean,$var=25, $p=0){
    if(needsInspection($p)){
        $capacity = round(stats_cdf_gamma(uniformRand(),0.5*$mean/$var,$var,2));
    }else{
        $capacity = round(stats_cdf_gamma(uniformRand(),1.5*$mean/$var,$var,2));
    }
    return $capacity;
}

function uniformRand(){
    return rand(1,999999)/1000000;
}

function cntGoutTime(){
    return round(dwellTime($GLOBALS['doc']['org']['cnt_dwell'],$GLOBALS['doc']['org']['cnt_dwell'],0.9,0.1))*24*60*60 + loadTimeOfDay($GLOBALS['doc']['org']['peack_hour']);
}

function cntRoadTime(){
    return round(dwellTime($GLOBALS['doc']['truck']['trip_time'],3,0.9,0.1)*60);
}

function addSec($date,$step){
    return date('Y-m-d H:i', strtotime($date. ' +'.$step.' seconds'));
}



$data = $_POST['data'];
$str = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $data) ;

// $str = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', file_get_contents('in.json')) ;
$json = json_decode($str, true);

simulate($json);

function simulate($doc){
    $startProcess = microtime(true);
    $GLOBALS['doc'] = $doc;
    $GLOBALS['doc']['org']['peack_hour'] = $GLOBALS['doc']['org']['peack_hour'] - 12;
    $totalSeconds = ($GLOBALS["doc"]['org']['cnt_dwell'] + $doc['settings']['duration']+$GLOBALS["doc"]['org']['cnt_dwell'])*24*60*60;
    $step = $doc['settings']['step'];
    $startTime = addSec('2020-01-01 00:00',$GLOBALS["doc"]['org']['cnt_dwell']*(-24*60*60*2));
    $GLOBALS['containers']=[];
    $GLOBALS['complete']=[];
    $GLOBALS['queues']=[];
    $GLOBALS['ramps']=[];
    $GLOBALS['waiting']=[];
    foreach ($GLOBALS["doc"]['dest']['inspection'] as $key => $insp) {
        foreach ($insp['ramps'] as $key => $value) {
            $GLOBALS['ramps'][$value]=null;
        }

        foreach ($insp['queues'] as $key => $value) {
            
            $found_key =  array_search($value, array_column($GLOBALS["doc"]['dest']['queues'], 'id'));
            $GLOBALS['queues'][$value]=array(
                "id"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['id'],
                "capacity"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['capacity'],
                "available"=>$GLOBALS["doc"]['dest']['queues'][$found_key]['capacity'],
                "containers"=>[]
            );
        }
    }
    $GLOBALS['overflow']=[];
    $voyage=[];
    $startInterval = $startTime;
    $steps = 0;
    for ($start=-1*$step; $start < $totalSeconds; $start=$start+$step) { // Mian simulation loop
        $complete_percentage = round($start/$totalSeconds*100); // To be sent to web socket

        $end = $start+$step;
        $steps++;
        $endInterval = addSec($startInterval,$step);
        $GLOBALS['currentTime']=$endInterval;
        if(date("d", strtotime($startInterval)) != date("d", strtotime($endInterval))){ // New Day Detected
            if($GLOBALS['doc']['supply']['supply_mode']=="random"){
                if(needsInspection($GLOBALS["doc"]['supply']['annual_rate']/365)){
                    $containersInVoyage = vesselCapacity($GLOBALS["doc"]['supply']['containers']);
                    createVoyageCnt($GLOBALS['containers'],$containersInVoyage,$endInterval);
                    $voyage[]=array("startTime"=>$endInterval,"containers"=>$containersInVoyage);
                }    
            }else{
                $dailyContainers = round($GLOBALS["doc"]['supply']['annual_rate'] * $GLOBALS["doc"]['supply']['containers'] /365);
                createVoyageCnt($dailyContainers,$endInterval);
                $voyage[]=array("startTime"=>$endInterval,"containers"=>$dailyContainers);
            }
        }

        foreach ($GLOBALS['containers'] as $id => $cnt) {
            updateCntStatus($GLOBALS['containers'][$id],$endInterval);
            checkCntId("main-".$id);
        }
       

        getNextQ();
        
        // debug("[".$GLOBALS['currentTime']."] - Ramps Capacity: ".$GLOBALS['inspection']['all_purpose']['available']."<br>");
        // debug("[".$GLOBALS['currentTime']."] - Queue Capacity: ".$GLOBALS['queues']['all_purpose']['available']."<br>");
        
        if($GLOBALS['currentTime']>'2020-01-01 00:00'){
            $output['snapshoot'][]=array("ts"=>$GLOBALS['currentTime'],"h"=>[],"s"=>[]);

            foreach ($GLOBALS['queues'] as $q => &$queue) {
                $i=0;
                foreach ($queue['containers'] as $cid) {
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]=$queue['id']."L".$i;
                    $i++;
                }
                for ($j=$i; $j < $queue['capacity']; $j++) { 
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]=$queue['id']."L".$j;
                }
            }
            foreach ($GLOBALS['ramps'] as $r => $cid) {
                if($cid != null){
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['s'][$GLOBALS['containers'][$cid]['inspection']['color']][]="R".$r;
                }else{
                    $output['snapshoot'][sizeof($output['snapshoot'])-1]['h'][]="R".$r;
                }
            }
            

            // echo $GLOBALS['currentTime']." ";
            // foreach ($GLOBALS['queues'] as $q => &$queue) {
            //     for ($i=0; $i < $queue['capacity']; $i++) { 
            //         if($i<$queue['capacity'] -$queue['available']){
            //             echo 1;
            //         }
            //     }
            // }
            // foreach ($GLOBALS['queues'] as $q => &$queue) {
            //     for ($i=0; $i < $queue['capacity']; $i++) { 
            //         if($i>=$queue['capacity'] -$queue['available']){
            //             echo 0;
            //         }
            //     }
            // }
            // echo ' ';
            // foreach ($GLOBALS['ramps'] as $r => &$ramp) {
            //     if($ramp != null){
            //         echo 1;
            //     }
            // }
            // foreach ($GLOBALS['ramps'] as $r => &$ramp) {
            //     if($ramp == null){
            //         echo 0;
            //     }
            // }
            // echo "\n";
        }
        //dump($GLOBALS['containers']); die;
        foreach ($GLOBALS['containers'] as $c => &$cnt) {
            if($cnt['inspection']['include']){
                if(isset($cnt['inspection']['overflow']["start"]) and isset($cnt['inspection']['overflow']["start"])){
                    $overflow = [$cnt['inspection']['overflow']["start"],$cnt['inspection']['overflow']["end"]];
                }else{
                    $overflow = [null,null];
                }
                $output['containers'][$cnt['status']][$cnt['inspection']['type']][]=
                    array(
                        $cnt['drop_time'],
                        $cnt['gout_time'],
                        $cnt['arrive_time'],
                        $cnt['inspection_start'],
                        $cnt['clear_start'],
                        $cnt['release_time'],
                        $overflow[0],$overflow[1]
                    );    
            }else{
                $output['containers'][$cnt['status']]['none'][]=
                    array(
                        $cnt['drop_time'],
                        $cnt['gout_time'],
                        $cnt['release_time']
                    );

            }
            
        }
        //debug("[".$GLOBALS['currentTime']."] - Queue overflow: ".sizeof($GLOBALS['queues']['overflow'])."<br>");
        $startInterval=$endInterval;
    }

    file_put_contents("output.json", json_encode($output));

    $v=[];
    foreach ($voyage as $key => $value) {
        if(!isset($v[substr($value['startTime'],0,7)]))$v[substr($value['startTime'],0,7)]=0;
        $v[substr($value['startTime'],0,7)] += $value['containers'];
    }
    $time_elapsed_secs = microtime(true) - $startProcess;
    debug("time elapse=".$time_elapsed_secs."<br>Containers=".sizeof($GLOBALS['containers']));
}

function getCntId(){
    $GLOBALS['cntSeq']=$GLOBALS['cntSeq']+1;
    return $GLOBALS['cntSeq'];
}
function createVoyageCnt($count,$ts){
    for ($i=0; $i < $count; $i++) {
        $id=getCntId();
        $GLOBALS['containers'][$id] = createCnt($id,$ts);
        updateCntStatus($GLOBALS['containers'][$id],$ts);
    }
}

function createCnt($id,$ts){
    $totalProb = 1;
    foreach ($GLOBALS["doc"]['dest']['inspection'] as $cargoType => $value) {
        $needsInspection = needsInspection($value['prob']/(100*$totalProb));
        $totalProb = $totalProb - $value['prob']/100;
        if($needsInspection){
            $inspection = array(
                "include"=> true,
                "type"=>$cargoType,
                "color"=>$value['color'],
                "time" => round(dwellTime($value['time'])*60)
            );
            break;
        } 
    }
    if(!$needsInspection){
        $inspection = array("include"=> false);
    }
    
    $cnt = array(
        "id"=>$id,
        "status"=>"voyage",
        "drop_time"=>9,
        "gout_time"=>9,
        "arrive_time"=>9,
        "inspection_start"=>9,
        "clear_start"=>9,
        "release_time"=>9,
        "inspection"=>$inspection
    );
    $cnt['drop_time']=$ts;
    $cnt['gout_time']=addSec($cnt['drop_time'], cntGoutTime());
    if($cnt['inspection']['include']){
        $cnt['arrive_time']=addSec($cnt['gout_time'], cntRoadTime());

    }else{
        $cnt['release_time']=addSec($cnt['gout_time'], cntRoadTime());
    }
    return $cnt;
}


function updateCntStatus(&$cnt,$ts){
    if($cnt['status']=="voyage" and $cnt['drop_time'] <= $ts) {
        $cnt['status']="origin";
    }

    if($cnt['status']=="origin" and $cnt['gout_time'] <= $ts ) {
        $cnt['status']="road";
    }

    if($cnt['status']=="road"){
        if($cnt['inspection']['include']){
            if($cnt['arrive_time'] <= $ts ) {
                // debug("[".$GLOBALS['currentTime']."] - Add to Q: ".$cnt['id']."<br>");
                addToQ($cnt);
            }
        }else{
            if($cnt['arrive_time'] <= $ts ) {
                release($cnt);
            }
        }
    }

    if($cnt['status']=="inspect" and $cnt['clear_start'] <= $ts){
        // debug( "[".$GLOBALS['currentTime']."] - Clear: ".$cnt['id']."<br>");
        clear($cnt);
    }
    if($cnt['status']=="clearing" and $cnt['release_time'] <= $ts){
        // debug( "[".$GLOBALS['currentTime']."] - release: ".$cnt['id']."<br>");
        release($cnt);
    }

}

function comp($a, $b , $key) {
    return ($a[$key]==$b[$key]?0:($a[$key]<$b[$key])?1:-1);
}
 
function addToQ(&$cnt){
    $inspSettings = $GLOBALS['doc']['dest']['inspection'][$cnt['inspection']['type']];
    $selectedQueue = null;
    $cnt['status']="queue";
    usort($GLOBALS['queues'],function($a,$b){return comp($a,$b,'available');}); 

    foreach($inspSettings['queues'] as $q) {
        $found_queue_idx = array_search($q, array_column($GLOBALS['queues'], 'id'));
        if($GLOBALS['queues'][$found_queue_idx]['available']>0){
            $selectedQueue = &$GLOBALS['queues'][$found_queue_idx];
            break;
        } 
    }
    if($selectedQueue == null){
        // add to overflow
        $GLOBALS['overflow'][]=$cnt['id'];
        $cnt['inspection']['overflow']["start"]=$GLOBALS['currentTime'];
    }else{
        $selectedQueue['available'] = $selectedQueue['available'] - 1;
        $selectedQueue['containers'][]=$cnt['id'];
        $cnt['inspection']['actualQueue']=$selectedQueue['id'];
    }
}

function removeQ(&$cnt){
    $found_queue_idx = array_search($cnt['inspection']['actualQueue'], array_column($GLOBALS['queues'], 'id'));
    $found_queue_idx = array_search($cnt['inspection']['actualQueue'], array_column($GLOBALS['queues'], 'id'));
    $GLOBALS['queues'][$found_queue_idx]['available']++;
    array_splice($GLOBALS['queues'][$found_queue_idx]['containers'],0,1);
    //debug("[".$GLOBALS['currentTime']."] - remove Q: ".$selectedLane." - ".$cnt['id']."<br>");
    getFromOverflow();
    
}

function getFromOverflow(){
    if(sizeof($GLOBALS['overflow'])){ 
        $cnt=&$GLOBALS['containers'][$GLOBALS['overflow'][0]];
        addToQ($cnt);
        $cnt['inspection']['overflow']["end"]=$GLOBALS['currentTime'];
        array_splice($GLOBALS['overflow'],0,1);
        //debug( "[".$GLOBALS['currentTime']."] - Remove Overflow: ".$cnt['id']."<br>");
    }
}

function checkCntId($fn){
    foreach ($GLOBALS['containers'] as $key => $value) {
        if($key!=$value['id']){
           // echo $fn." - ".$key;
           // dump($GLOBALS['containers']);
           // die;
        }
    }
}
function getNextQ($counter=1){
    usort($GLOBALS['queues'],function($b,$a){return comp($a,$b,'available');});
    $inpectionDone = false;
    foreach ($GLOBALS['queues'] as &$queue) {
        if(sizeof($queue['containers'])){
            $type = $GLOBALS['containers'][$queue['containers'][0]]['inspection']['type'];
            $targetRamps = $GLOBALS['doc']['dest']['inspection'][$type]['ramps'];
            foreach ($targetRamps as $key => $rampIdx) {
                if($GLOBALS['ramps'][$rampIdx] == null){
                    inspect($GLOBALS['containers'][$queue['containers'][0]],$rampIdx);
                    $inpectionDone = true;
                    break;
                }
            }
        }
    }
    if($inpectionDone){
        getNextQ($counter++);
    }
}

function inspectiontimeShift($ts){
    $ts=substr($ts,11,2)*60*60+substr($ts,14,2)*60;
    $start = substr($GLOBALS['doc']['dest']['working_hours']['start'],0,2) *60*60 +
            substr($GLOBALS['doc']['dest']['working_hours']['start'],2,2) *60;
    $end = substr($GLOBALS['doc']['dest']['working_hours']['end'],0,2) *60*60 +
            substr($GLOBALS['doc']['dest']['working_hours']['end'],2,2) *60;
    
    if($ts>$end){
        $shift = 24*60*60 - $ts + $start;
    }elseif($ts<$start){
        $shift = $start - $ts;
    }else{
        $shift = 0;
    }
    return $shift;
}


function seconds($ts){
    return substr($ts,11,2)*60+substr($ts,14,2)*60*60;
}

function inspect(&$cnt,$rampId){
    $ramp = &$GLOBALS['ramps'][$rampId];
    removeQ($cnt);
    $GLOBALS['ramps'][$rampId]=$cnt['id'];
    $cnt['status']="inspect";
    $duration = $GLOBALS['doc']['dest']['inspection'][$cnt['inspection']['type']]['time'];
    $duration = round(dwellTime($duration)*60);
    $cnt['inspection_start']=addSec($GLOBALS['currentTime'],inspectiontimeShift($GLOBALS['currentTime']));
    $cnt['clear_start']=addSec($cnt['inspection_start'],$duration);
    $cnt['inspection']['actualRamp']=$rampId;
    // debug( "[".$GLOBALS['currentTime']."] - inspect: ".$cnt['id']."<br>");

}

function clear(&$cnt){
    $cnt['status']="clearing";
    $selectedRamp=$cnt['inspection']['actualRamp'];
    $cnt['release_time']=addSec($cnt['clear_start'],round(dwellTime($GLOBALS["doc"]["dest"]['clear']['time']*60)));
    unset($GLOBALS['ramps'][$cnt['inspection']['actualRamp']]);
    //$GLOBALS['waiting'][]=$cnt['id']; 
    $GLOBALS['ramps'][$cnt['inspection']['actualRamp']] = null;
    getNextQ();
}

function release(&$cnt){
    $cnt['status']="release";
    $GLOBALS['complete'][$cnt['id']]=$cnt;
    $idx = array_search($cnt['id'], $GLOBALS['complete']);
    // if($idx){
    //     echo $idx; 
    //     dump($GLOBALS['waiting']); die;
    //     array_splice($GLOBALS['overflow'],0,1);

    //     unset($GLOBALS['waiting'][$cnt['id']]);
    //     dump($GLOBALS['waiting']); die;
    // }
    
    //unset($GLOBALS['containers'][$cnt['id']]);
}
